import java.rmi.*;

/**
 * Classe che implementa l'interfaccia IIDUnique.
 * La classe permette di avere un generatore di stringhe diverse l'una dall'altra
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class IDUniqueImpl extends java.rmi.server.UnicastRemoteObject implements IIDUnique {

	protected long  value;
	
	/**
	 * Costruttore di default che inizializza il valore della variabile
	 * univoca a zero 
	 * @throws RemoteException
	 */
	public IDUniqueImpl()throws RemoteException{
		super();
		value=0;
	}
	
	/**
	 * Costruttore con un parametro che mi indicaca da quale cvalore iniziare
	 * a contare per creare gli id univoci
	 * @param v numero positivo da cui inizio a creare gli id
	 * @throws RemoteException
	 */
	public IDUniqueImpl(long v)throws RemoteException{
		super();
		value=v;
	}
	
	/**
	 * Metodo che ritorna la stringa univoca.
	 * Stringa formata da una base data in ingresso se diversa da null e un
	 * valore numerico che viene incrementato ogni volta
	 * @param base stringa base della stringa univoca
	 * @return una stringa che rappresenta un identificativo univoco
	 */
	public synchronized String nextName(String base) throws RemoteException {
		String response=null;
		if(base!=null)
			response=base+value;
		else 
			response=""+value;
		value++;
		return response;
	}

}
